### 23.7.2. 松散的绑定（Relaxed binding）

Spring Boot使用一些宽松的规则用于绑定Environment属性到@ConfigurationProperties beans，所以Environment属性名和bean属性名不需要精确匹配。常见的示例中有用的包括虚线分割（比如，context--path绑定到contextPath）和将环境属性转为大写字母（比如，PORT绑定port）。

示例：
```java
@Component
@ConfigurationProperties(prefix="person")
public class ConnectionSettings {
    private String firstName;
}
```
下面的属性名都能用于上面的@ConfigurationProperties类：

| 属性        | 说明   |
| --------    | :----- |
|person.firstName|标准驼峰规则|
|person.first-name|虚线表示，推荐用于.properties和.yml文件中|
|PERSON_FIRST_NAME|大写形式，使用系统环境变量时推荐|

Spring会尝试强制外部的应用属性在绑定到@ConfigurationProperties beans时类型是正确的。如果需要自定义类型转换，你可以提供一个ConversionService bean（bean id为conversionService）或自定义属性编辑器（通过一个CustomEditorConfigurer bean）。
